/* ============ */
/* xtendefs.h	*/
/* ============ */
/* ==================================================================== */
/* 	      DEFINITIONS FOR EXTENDED PRECISION FUNCTIONS		*/
/* ==================================================================== */

# if defined(__XTENDEFS_H__)
#	/* Do Nothing */
# else
#	define	__XTENDEFS_H__

#if !defined(__XQHEAD_H__)
#	include "xqhead.h"
# endif

typedef	unsigned short	USHORT;
typedef	long double	LDBL;
typedef	USHORT 		QELEM[NE];
typedef	USHORT	       *QPTR;

#define	FALSE	0
#define	TRUE	1

#define	ASCTOX(S, X)			asctoq(S, X)
#define	DBLTOX(D, X)			etoq(&D, X)
#define	LDBLTOX(L, X)			e64toq(&L, X)
#define	LONGTOX(n, X)			ltoq(&n, X)
#define	XABS(X)				qabs(X)
#define	XADD(X, Y, R)			qadd(X, Y, R)
#define	XCLEAR(X)			qclear(X)
#define	XCMP(X, Y)			qcmp(X, Y)
#define	XCOPY(X, R)			qmov(X, R)
#define	XDIV(X, Y, R)			qdiv(Y, X, R)
#define	XEQUAL(X, Y)			(XCMP(X, Y) == 0)
#define	XEXP(X, R)			qexp(X, R)
#define	XFLOOR(X, R)			qfloor(X, R)
#define	XFPRINTF(U, S, X, N)		\
    {					\
	char	Str[128];		\
	XTOASC(X, Str, N);		\
	fprintf(U, "%s%s\n", S, Str);	\
    }
#define	XGT(X, Y)			(XCMP(X, Y) > 0)
#define	XGTE(X, Y)			(XCMP(X, Y) >= 0)
#define	XLOG(X, R)			qlog(X, R)
#define	XLT(X, Y)			(XCMP(X, Y) == -1)
#define	XLTE(X, Y)			(XEQUAL(X, Y) || XCMP(X, Y) == -1)
#define	XMAX(X, Y, R)			\
    {                                   \
	if (XGT(X, Y))                  \
	    XCOPY(X, R);                \
	else                            \
	    XCOPY(Y, R);                \
    }
#define	XMIN(X, Y, R)			\
    {                                   \
	if (XGT(Y, X))                  \
	    XCOPY(X, R);                \
	else                            \
	    XCOPY(Y, R);                \
    }
#define	XML(r, c, D)			(((r-1) * D + (c-1)) * NE)

#define	XMOD(X, Y, R)			qremain(Y, X, R) /* XMod(X, Y, R) */
#define	XMULT(X, Y, R)			qmul(X, Y, R)
#define	XNEG(X)				qneg(X)
#define	XPOW(X, Y, R)			qpow(X, Y, R)
#define	XPRINTF(S, X, N)		XFPRINTF(stdout, S, X, N)
#define	XRADD(X, Y)			XADD(X, Y, X)
#define	XRDIV(X,Y)			XDIV(X, Y, X)
#define	XRMULT(X, Y)			XMULT(X, Y, X)
#define	XROUND(X, R)			qround(X, R)
#define	XRSUB(X, Y)			XSUB(X, Y, X)
#define	XSQR(X, R)			XMULT(X, X, R)
#define	XSQRT(X, R)			qsqrt(X, R)
#define	XSUB(X, Y, R)			qsub(Y, X, R)
#define	XSWAP(X, Y)			\
    {					\
	USHORT	H;			\
	short	i;			\
	for (i = 0; i < NE; ++i)	\
	{				\
	    H = X[i];			\
	    X[i] = Y[i];		\
	    Y[i] = H;			\
	}				\
    }
#define	XTOASC(X, S, N)			qtoasc(X, S, N)
#define	XTODBL(X, D)			qtoe(X, &D)
#define	XTOLDBL(X, L)			qtoe64(X, &L)
#define	XTST(X)				XCMP(X, EZERO)
#define	XURAND(X)                       qrand(X)
#define	XVL(en)				((en-1) * NE)

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */

extern	int	addm	F((void *, void *));
extern	int	asctoq	F((char *, void *));
extern	int	cmpm	F((void *, void *));
extern	int	divm	F((void *, void *));
extern	int	dtoq	F((void *, void *));
extern	int	e113toq	F((void *, void *));
extern	int	e64toq	F((void *, void *));
extern	int	etoq	F((void *, void *));
extern	int	ltoq	F((long *, void *));
extern	int	mtherr	F((char *, int));
extern	int	mulin	F((void *, void *));
extern	int	mulm	F((void *, void *));
extern	int	normlz	F((void *));
extern	int	qabs	F((void *));
extern	int	qadd	F((void *, void *, void *));
extern	int	qadd1	F((void *, void *, void *));
extern	int	qclear	F((void *));
extern	int	qcmp	F((void *, void *));
extern	int	qdiv	F((void *, void *, void *));
extern	int	qexp	F((void *, void *));
extern	int	qfloor	F((void *, void *));
extern	int	qifrac	F((void *, long *, void *));
extern	int	qinfin	F((void *));
extern	int	qisneg	F((void *));
extern	int	qldexp	F((void *, int));
extern	int	qlog	F((void *, void *));
extern	int	qmov	F((void *, void *));
extern	int	qmovz	F((void *, void *));
extern	int	qmul	F((void *, void *, void *));
extern	int	qmuli	F((void *, void *, void *));
extern	int	qneg	F((void *));
extern	int	qnrmlz	F((void *));
extern	int	qpow	F((void *, void *, void *));
extern	int	qpowi	F((void *, void *, void *));
extern	int	qrand	F((void *));
extern	int	qremain	F((void *, void *, void *));
extern	int	qround	F((void *, void *));
extern	int	qsqrt	F((void *, void *));
extern	void	qsrand	F((unsigned int));
extern	int	qsub	F((void *, void *, void *));
extern	int	qtanh	F((void *, void *));
extern	int	qtoasc	F((void *, char *, int));
extern	int	qtod	F((void *, void *));
extern	int	qtoe	F((void *, void *));
extern	int	qtoe113	F((void *, void *));
extern	int	qtoe64	F((void *, void *));
extern	int	shdn1	F((void *));
extern	int	shdn16	F((void *));
extern	int	shdn8	F((void *));
extern	int	shift	F((void *));
extern	int	shup1	F((void *));
extern	int	shup16	F((void *));
extern	int	shup8	F((void *));
extern	int	subm	F((void *, void *));

# undef	F
/* INDENT ON */

# endif
